// FB Alpha - Emulator for MC68000/Z80 based arcade games
//            Refer to the "license.txt" file for more info

// Main module

#include "burner.h"
#include <xtl.h>
#include <string>
#include <vector>

using namespace std;
int CreateROMInfo();
int MediaInit();
int DrvInit(int nDrvNum, bool bRestore);
int RunMessageLoop();
long int nMainThreadID;
int nAppThreadPriority = 0;
int nAppShowCmd;
static TCHAR szCmdLine[1024] = _T("");
int nAppVirtualFps = 6000;			// App fps * 100
TCHAR szAppBurnVer[16] = _T("");
bool bCmdOptUsed = 0;
bool bAlwaysProcessKeyboardInput = false;
bool bNoChangeNumLock = 0;
static bool bNumlockStatus;
bool bMonitorAutoCheck = true;
#include <string>
TCHAR szChoice[260] = _T("");
extern bool OutOfMemory;
extern "C" int dprintf(char *format, ...);
extern void AudioInit();
extern int ConfigCheatLoad();
extern bool bCheatsAllowed;
extern int StatedAuto(int bSave);
extern bool PrintDip();
extern int DipEnabled;
extern std::string ConfigPath;
extern "C" int dprintf(char *format, ...);
extern unsigned short CPUSpeed;
extern void SaveGameIni(std::string e);
extern vector<string> GeneralOptionsValueSettings;

TCHAR* ANSIToTCHAR(const char* pszInString, TCHAR* pszOutString, int /*nOutSize*/)
{
	if (pszOutString) {
		_tcscpy(pszOutString, pszInString);
		return pszOutString;
	}

	return (TCHAR*)pszInString;
}

char* TCHARToANSI(const TCHAR* pszInString, char* pszOutString, int /*nOutSize*/)
{
	if (pszOutString) {
		strcpy(pszOutString, pszInString);
		return pszOutString;
	}

	return (char*)pszInString;
}

// Main program entry point
int SegaMain(std::string game) {
	//dprintf("SegaMain Start\n");
	OutOfMemory = false;
	bCheatsAllowed = true;
	//dprintf("BurnLibInit Start\n");
	BurnLibInit();
	//dprintf("ComputeGammaLUT Start\n");
	ComputeGammaLUT();
	unsigned int i;
	bool bFullscreen = 1;
	bCmdOptUsed = 1;
	//dprintf("Find Game.\n");
	for (i = 0; i < nBurnDrvCount; i++) {
		nBurnDrvActive = i;
		if (_tcscmp(BurnDrvGetText(DRV_NAME), game.c_str()) == 0) {	
			if ((_tcscmp(game.c_str(), "asurabld") == 0) || 
				(_tcscmp(game.c_str(), "asurabus") == 0) || 
				(_tcscmp(game.c_str(), "sf") == 0) || 
				(_tcscmp(game.c_str(), "sfj") == 0) || 
				(_tcscmp(game.c_str(), "sfp") == 0) || 
				(_tcscmp(game.c_str(), "sfus") == 0) || 
				(_tcscmp(game.c_str(), "cclimbr2") == 0) || 
				(_tcscmp(game.c_str(), "cclimbr2a") == 0) || 
				(_tcscmp(game.c_str(), "crimfght") == 0) || 
				(_tcscmp(game.c_str(), "crimfghtj") == 0) || 
				(_tcscmp(game.c_str(), "crimfghtu") == 0) || 
				(_tcscmp(game.c_str(), "crimfght2") == 0) || 
				(_tcscmp(game.c_str(), "mcatadv") == 0) || 
				(_tcscmp(game.c_str(), "catt") == 0) || 
				(_tcscmp(game.c_str(), "mcatadvj") == 0) || 
				(_tcscmp(game.c_str(), "bssoccer") == 0) || 
				(_tcscmp(game.c_str(), "bombkick") == 0) || 
				(_tcscmp(game.c_str(), "explbrkr") == 0) || 
				(_tcscmp(game.c_str(), "bakubrkr") == 0) || 
				(_tcscmp(game.c_str(), "f1gp") == 0) || 
				(_tcscmp(game.c_str(), "f1gp2") == 0) || 
				(_tcscmp(game.c_str(), "firehawk") == 0) || 
				(_tcscmp(game.c_str(), "gigandes") == 0) || 
				(_tcscmp(game.c_str(), "gigandesj") == 0) || 
				(_tcscmp(game.c_str(), "grdnstrm") == 0) || 
				(_tcscmp(game.c_str(), "grdnstrmk") == 0) || 
				(_tcscmp(game.c_str(), "magicbub") == 0) || 
				(_tcscmp(game.c_str(), "magicbuba") == 0) || 
				(_tcscmp(game.c_str(), "mangchi") == 0) || 
				(_tcscmp(game.c_str(), "nost") == 0) || 
				(_tcscmp(game.c_str(), "nostj") == 0) || 
				(_tcscmp(game.c_str(), "nostk") == 0) || 
				(_tcscmp(game.c_str(), "higemaru") == 0) || 
				(_tcscmp(game.c_str(), "popspops") == 0) || 
				(_tcscmp(game.c_str(), "rollerg") == 0) || 
				(_tcscmp(game.c_str(), "rollergj") == 0) || 
				(_tcscmp(game.c_str(), "spec2k") == 0) || 
				(_tcscmp(game.c_str(), "suratk") == 0) || 
				(_tcscmp(game.c_str(), "suratka") == 0) || 
				(_tcscmp(game.c_str(), "suratkj") == 0) || 
				(_tcscmp(game.c_str(), "vliner") == 0) || 
				(_tcscmp(game.c_str(), "vlinero") == 0) || 
				(_tcscmp(game.c_str(), "bestbest") == 0) || 
				(_tcscmp(game.c_str(), "buccanrs") == 0) || 
				(_tcscmp(game.c_str(), "buccanrsa") == 0) || 
				(_tcscmp(game.c_str(), "garyoret") == 0) || 
				(_tcscmp(game.c_str(), "arkanoid") == 0) || 
				(_tcscmp(game.c_str(), "arkanoidu") == 0) || 
				(_tcscmp(game.c_str(), "arkanoiduo") == 0) || 
				(_tcscmp(game.c_str(), "arkatour") == 0) || 
				(_tcscmp(game.c_str(), "arkanoidj") == 0) || 
				(_tcscmp(game.c_str(), "arkanoidjb") == 0) || 
				(_tcscmp(game.c_str(), "ark1ball") == 0) || 
				(_tcscmp(game.c_str(), "arkangc") == 0) || 
				(_tcscmp(game.c_str(), "arkangc2") == 0) || 
				(_tcscmp(game.c_str(), "arkblock") == 0) || 
				(_tcscmp(game.c_str(), "arkbloc2") == 0) || 
				(_tcscmp(game.c_str(), "arkgcbl") == 0) || 
				(_tcscmp(game.c_str(), "paddle2") == 0) || 
				(_tcscmp(game.c_str(), "arkatayt") == 0) ||
				(_tcscmp(game.c_str(), "arktayt2") == 0) || 
				(_tcscmp(game.c_str(), "multchmp") == 0) ||	// added to fbl due to crash on start 06-28-2012
				(_tcscmp(game.c_str(), "extdwnhl") == 0) || // added to fbl due to crash on start, confirmed op 06/2012
				(_tcscmp(game.c_str(), "galaga") == 0) || // added to fbl due to crash on start possible fix in d_galaga.cpp confirmed op 06/2012
				(_tcscmp(game.c_str(), "galagao") == 0) ||
				(_tcscmp(game.c_str(), "galagamk") == 0) ||
				(_tcscmp(game.c_str(), "galagamw") == 0) ||
				(_tcscmp(game.c_str(), "galagamf") == 0) ||
				(_tcscmp(game.c_str(), "uballoon") == 0) ||
				(_tcscmp(game.c_str(), "selfeena") == 0) ||
				(_tcscmp(game.c_str(), "silentd") == 0) ||
				(_tcscmp(game.c_str(), "silentdj") == 0) ||
				(_tcscmp(game.c_str(), "silentdu") == 0) ||
			    (_tcscmp(game.c_str(), "spec2kh") == 0) || 
				(_tcscmp(game.c_str(), "stagger1") == 0) ||
				(_tcscmp(game.c_str(), "bigstrik") == 0) ||
				(_tcscmp(game.c_str(), "lomakai") == 0) ||
				(_tcscmp(game.c_str(), "astyanax") == 0) ||
				(_tcscmp(game.c_str(), "terraf") == 0) ||
				(_tcscmp(game.c_str(), "terrafu") == 0) ||
				(_tcscmp(game.c_str(), "terrafj") == 0) ||
				(_tcscmp(game.c_str(), "terrafjb") == 0) ||
				(_tcscmp(game.c_str(), "terrafb") == 0) ||
				(_tcscmp(game.c_str(), "robokid") == 0) ||
				(_tcscmp(game.c_str(), "robokidj") == 0) ||
				(_tcscmp(game.c_str(), "robokidj2") == 0) ||
				(_tcscmp(game.c_str(), "omegaf") == 0) ||
				(_tcscmp(game.c_str(), "omegafs") == 0) ||
				(_tcscmp(game.c_str(), "pspikes") == 0) ||
				(_tcscmp(game.c_str(), "pspikesk") == 0) ||
				(_tcscmp(game.c_str(), "pspikesu") == 0) ||
				(_tcscmp(game.c_str(), "svolly91") == 0) ||
				(_tcscmp(game.c_str(), "hopmappy") == 0) ||
				(_tcscmp(game.c_str(), "bublbobl") == 0) ||
				(_tcscmp(game.c_str(), "bublbobl1") == 0) ||
				(_tcscmp(game.c_str(), "bublboblr") == 0) ||
				(_tcscmp(game.c_str(), "bublboblr1") == 0) ||
				(_tcscmp(game.c_str(), "bublboblp") == 0) ||
				(_tcscmp(game.c_str(), "boblbobl") == 0) ||
				(_tcscmp(game.c_str(), "sboblboa") == 0) ||
				(_tcscmp(game.c_str(), "sboblbob") == 0) ||
				(_tcscmp(game.c_str(), "bub68705") == 0) ||
				(_tcscmp(game.c_str(), "dland") == 0) ||
				(_tcscmp(game.c_str(), "bublcave") == 0) ||
				(_tcscmp(game.c_str(), "bublcave11") == 0) ||
				(_tcscmp(game.c_str(), "bublcave10") == 0) ||
				(_tcscmp(game.c_str(), "chimerab") == 0) ||
				(_tcscmp(game.c_str(), "nemesis") == 0) ||
				(_tcscmp(game.c_str(), "nemesisuk") == 0) ||
				(_tcscmp(game.c_str(), "konamigt") == 0) ||
				(_tcscmp(game.c_str(), "salamand") == 0) ||
				(_tcscmp(game.c_str(), "salamandj") == 0) ||
				(_tcscmp(game.c_str(), "lifefrce") == 0) ||
				(_tcscmp(game.c_str(), "lifefrcej") == 0) ||
				(_tcscmp(game.c_str(), "twinbee") == 0) ||
				(_tcscmp(game.c_str(), "gradius") == 0) ||
				(_tcscmp(game.c_str(), "gwarrior") == 0) ||
				(_tcscmp(game.c_str(), "rf2") == 0) ||
				(_tcscmp(game.c_str(), "blkpnthr") == 0) ||
				(_tcscmp(game.c_str(), "citybomb") == 0) ||
				(_tcscmp(game.c_str(), "citybombj") == 0) ||
				(_tcscmp(game.c_str(), "kittenk") == 0) ||
				(_tcscmp(game.c_str(), "nyanpani") == 0) ||
				(_tcscmp(game.c_str(), "hcrash") == 0) ||
				(_tcscmp(game.c_str(), "hcrashc") == 0) ||
				(_tcscmp(game.c_str(), "mystston") == 0) ||
				(_tcscmp(game.c_str(), "athena") == 0) ||
				(_tcscmp(game.c_str(), "hal21") == 0) ||
			    (_tcscmp(game.c_str(), "hal21j") == 0) ||
				(_tcscmp(game.c_str(), "aso") == 0) ||
				(_tcscmp(game.c_str(), "bermudat") == 0) ||
				(_tcscmp(game.c_str(), "bermudata") == 0) ||
				(_tcscmp(game.c_str(), "bermudatj") == 0) ||
				(_tcscmp(game.c_str(), "worldwar") == 0) ||
				(_tcscmp(game.c_str(), "sgladiat") == 0) ||
				(_tcscmp(game.c_str(), "sgladiat") == 0) ||
				(_tcscmp(game.c_str(), "darwin") == 0) ||
				(_tcscmp(game.c_str(), "metlfrzr") == 0) ||
				(_tcscmp(game.c_str(), "thedeep") == 0) ||
				(_tcscmp(game.c_str(), "rundeep") == 0) ||
				(_tcscmp(game.c_str(), "parodius") == 0) ||
				(_tcscmp(game.c_str(), "parodiuse") == 0) ||
				(_tcscmp(game.c_str(), "parodiusj") == 0) ||
				(_tcscmp(game.c_str(), "parodiusa") == 0) ||
				(_tcscmp(game.c_str(), "gradius3") == 0) ||
				(_tcscmp(game.c_str(), "gradius3j") == 0) ||
				(_tcscmp(game.c_str(), "gradius3js") == 0) ||
				(_tcscmp(game.c_str(), "gradius3a") == 0) ||
				(_tcscmp(game.c_str(), "ajax") == 0) ||
				(_tcscmp(game.c_str(), "ajaxj") == 0) ||
				(_tcscmp(game.c_str(), "typhoon") == 0) ||
				(_tcscmp(game.c_str(), "88games") == 0) ||
				(_tcscmp(game.c_str(), "konami88") == 0) ||
				(_tcscmp(game.c_str(), "hypsptsp") == 0) ||
				(_tcscmp(game.c_str(), "drgnunit") == 0) ||
				(_tcscmp(game.c_str(), "opwolf") == 0) ||
				(_tcscmp(game.c_str(), "opwolfa") == 0) ||
				(_tcscmp(game.c_str(), "opwolfj") == 0) ||
				(_tcscmp(game.c_str(), "opwolfjsc") == 0) ||
				(_tcscmp(game.c_str(), "opwolfu") == 0) ||
                (_tcscmp(game.c_str(), "opwolfb") == 0) ||
				(_tcscmp(game.c_str(), "choplift") == 0) ||
				(_tcscmp(game.c_str(), "chopliftu") == 0) ||
				(_tcscmp(game.c_str(), "chopliftbl") == 0) ||
				(_tcscmp(game.c_str(), "ufosensi") == 0) ||
				(_tcscmp(game.c_str(), "viofight") == 0) ||
				(_tcscmp(game.c_str(), "viofightu") == 0) ||
				(_tcscmp(game.c_str(), "viofightj") == 0) ||
				(_tcscmp(game.c_str(), "syvalion") == 0) ||
				(_tcscmp(game.c_str(), "syvalionp") == 0) ||
				(_tcscmp(game.c_str(), "recordbr") == 0) ||
				(_tcscmp(game.c_str(), "gogold") == 0) ||
				(_tcscmp(game.c_str(), "tetristh") == 0) ||
				(_tcscmp(game.c_str(), "dleague") == 0) ||
				(_tcscmp(game.c_str(), "dleaguej") == 0) ||
				(_tcscmp(game.c_str(), "daioh") == 0) ||
				(_tcscmp(game.c_str(), "blockcar") == 0) ||
				(_tcscmp(game.c_str(), "gundhara") == 0) ||
				(_tcscmp(game.c_str(), "Sokonuke") == 0) ||
				(_tcscmp(game.c_str(), "superbar") == 0) ||
				(_tcscmp(game.c_str(), "thunderl") == 0) ||
				(_tcscmp(game.c_str(), "wiggie") == 0) ||
				(_tcscmp(game.c_str(), "wits") == 0) ||
				(_tcscmp(game.c_str(), "bublboblu") == 0) ||
				(_tcscmp(game.c_str(), "nastar") == 0) ||
				(_tcscmp(game.c_str(), "rastsag2") == 0) ||
				(_tcscmp(game.c_str(), "nastarw") == 0) ||
				(_tcscmp(game.c_str(), "rambo3") == 0) ||
				(_tcscmp(game.c_str(), "rambo3u") == 0) ||
				(_tcscmp(game.c_str(), "rambo3p") == 0) ||
				(_tcscmp(game.c_str(), "splatter") == 0) ||
				(_tcscmp(game.c_str(), "splatter2") == 0) ||
				(_tcscmp(game.c_str(), "splatterj") == 0) ||
				(_tcscmp(game.c_str(), "blastoff") == 0) ||
				(_tcscmp(game.c_str(), "quester") == 0) ||
				(_tcscmp(game.c_str(), "questers") == 0) ||
				(_tcscmp(game.c_str(), "rompers") == 0) ||
				(_tcscmp(game.c_str(), "romperso") == 0) ||
				(_tcscmp(game.c_str(), "wheelrun") == 0) ||
				(_tcscmp(game.c_str(), "chaknpop") == 0) ||
				(_tcscmp(game.c_str(), "junofrst") == 0) ||
				(_tcscmp(game.c_str(), "junofrstg") == 0) ||
				(_tcscmp(game.c_str(), "enforce") == 0) ||
				(_tcscmp(game.c_str(), "bottom9") == 0) ||
				(_tcscmp(game.c_str(), "bottom9n") == 0) ||
				(_tcscmp(game.c_str(), "mstadium") == 0) ||
				(_tcscmp(game.c_str(), "mugsmash") == 0) ||
				(_tcscmp(game.c_str(), "nmouse") == 0) ||
				(_tcscmp(game.c_str(), "nmouseb") == 0) ||
				(_tcscmp(game.c_str(), "sokonuke") == 0) ||
				(_tcscmp(game.c_str(), "tutankhm") == 0) ||
				(_tcscmp(game.c_str(), "tutankhms") == 0) ||
				(_tcscmp(game.c_str(), "yiear") == 0) ||
				(_tcscmp(game.c_str(), "yiear2") == 0) ||
				(_tcscmp(game.c_str(), "sidearms") == 0) ||
				(_tcscmp(game.c_str(), "sidearmsu") == 0) ||
				(_tcscmp(game.c_str(), "sidearmsur1") == 0) ||
				(_tcscmp(game.c_str(), "sidearmsj") == 0) ||
				(_tcscmp(game.c_str(), "mappy") == 0) ||
                (_tcscmp(game.c_str(), "mappyj") == 0) ||
                (_tcscmp(game.c_str(), "digdug2") == 0) ||
                (_tcscmp(game.c_str(), "digdug2o") == 0) ||
                (_tcscmp(game.c_str(), "todruaga") == 0) ||
                (_tcscmp(game.c_str(), "todruagao") == 0) ||
                (_tcscmp(game.c_str(), "todruagas") == 0) ||
                (_tcscmp(game.c_str(), "motos") == 0) ||
                (_tcscmp(game.c_str(), "superpac") == 0) ||
                (_tcscmp(game.c_str(), "superpacm") == 0) ||
                (_tcscmp(game.c_str(), "pacnpal") == 0) ||
                (_tcscmp(game.c_str(), "pacnpal2") == 0) ||
                (_tcscmp(game.c_str(), "pacnchmp") == 0) ||
                (_tcscmp(game.c_str(), "grobda") == 0) ||
                (_tcscmp(game.c_str(), "grobda2") == 0) ||
                (_tcscmp(game.c_str(), "grobda3") == 0) ||
                (_tcscmp(game.c_str(), "phozon") == 0) ||
                (_tcscmp(game.c_str(), "phozons") == 0) ||
				(_tcscmp(game.c_str(), "gaplus") == 0) ||
                (_tcscmp(game.c_str(), "gaplusa") == 0) ||
                (_tcscmp(game.c_str(), "gaplusd") == 0) ||
                (_tcscmp(game.c_str(), "gaplust") == 0) ||
                (_tcscmp(game.c_str(), "galaga3") == 0) ||
                (_tcscmp(game.c_str(), "galaga3a") == 0) ||
                (_tcscmp(game.c_str(), "galaga3b") == 0) ||
                (_tcscmp(game.c_str(), "galaga3c") == 0) ||
                (_tcscmp(game.c_str(), "galaga3m") == 0) ||
				(_tcscmp(game.c_str(), "hangzo") == 0) ||
				(_tcscmp(game.c_str(), "liblrabl") == 0) ||
				(_tcscmp(game.c_str(), "toypop") == 0) ||
				(_tcscmp(game.c_str(), "pacland") == 0) ||
				(_tcscmp(game.c_str(), "paclandj") == 0) ||
				(_tcscmp(game.c_str(), "paclandjo") == 0) ||
				(_tcscmp(game.c_str(), "paclandjo2") == 0) ||
				(_tcscmp(game.c_str(), "paclandm") == 0) ||
				(_tcscmp(game.c_str(), "goldmedl") == 0) ||
				(_tcscmp(game.c_str(), "goldmedla") == 0) ||
				(_tcscmp(game.c_str(), "goldmedlb") == 0) ||
				(_tcscmp(game.c_str(), "thunderx") == 0) ||
				(_tcscmp(game.c_str(), "scontra") == 0) ||
				(_tcscmp(game.c_str(), "alpine") == 0) ||
				(_tcscmp(game.c_str(), "alpinea") == 0) ||
				(_tcscmp(game.c_str(), "junglek") == 0) ||
				(_tcscmp(game.c_str(), "junglekas") == 0) ||
				(_tcscmp(game.c_str(), "jungleby") == 0) ||
				(_tcscmp(game.c_str(), "junglekj2") == 0) ||
				(_tcscmp(game.c_str(), "jungleh") == 0) ||
				(_tcscmp(game.c_str(), "junglehbr") == 0) ||
				(_tcscmp(game.c_str(), "piratpet") == 0) ||
				(_tcscmp(game.c_str(), "sfposeid") == 0) ||
				(_tcscmp(game.c_str(), "mofflott") == 0)) {	
					DipEnabled = 0;
					GeneralOptionsValueSettings[1] = "False";
					SaveGameIni(BurnDrvGetTextA(0));
			}
			//dprintf("AudioInit\n");
			AudioInit();
/*			if(!DipEnabled) {
				if ((_tcscmp(game.c_str(), "forgottn") != 0) && 
					(_tcscmp(game.c_str(), "forgottnu") != 0) &&
					(_tcscmp(game.c_str(), "lostwrld") != 0)) {	
					char fileName[260];
					sprintf(fileName, "%s%s%s.ini", ConfigPath.c_str(), "\\games\\", BurnDrvGetText(DRV_NAME));
					DeleteFile(fileName);
				}
			}*/
			DrvInit(i, true);
			if(BurnDrvGetHardwareCode() != HARDWARE_SEGA_MEGADRIVE) {
				if(DipEnabled) {
					if(!PrintDip()) {
						DipEnabled = 0;
						GeneralOptionsValueSettings[1] = "False";
						SaveGameIni(BurnDrvGetTextA(0));
					}
				}
			}
			//dprintf("ConfigCheatLoad Start\n");
			ConfigCheatLoad();
			//dprintf("ConfigCheatLoad End\n");
			//dprintf("MediaInit Start\n");
			MediaInit();
			//dprintf("MediaInit End\n");
			bCheatsAllowed = true;
			//dprintf("StatedAuto(0); Start\n");
			StatedAuto(0);
			break;
		}
	}
	//dprintf("SegaMain End\n");
	nBurnCPUSpeedAdjust = CPUSpeed;
	RunMessageLoop();
	return 0;
}
